 ; Ŀ
 ;   Bracket - attach a bracket to the end of two lines.                   
 ;   Copyright 1993, 1994 by Rocket Software Ltd.                          
 ;   Given the uneven surface found on most motherboards, a crocodile      
 ;   does not make a very effective heat sink.                             
 ; 
 (DEFUN C:BRACKET (/ blip oss pa pb pta ptb enda endb angg abang abdist pk xpa
                  ypa xpk ypk verti horiz radi height p2 p3 p4 p5 p6 p7 p8 p9 
                  p10 p11)
  (setvar "cmdecho" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq oss (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   First get two lines and see which ends we are working from.           
 ;   Need two endpoints and the direction away from the lines.             
 ; 
  (setq pa (entsel "Select a line: "))
  (setq pb (entsel "\nAnd another: "))
  (if (and pa pb)
      (progn
           (setq pta (cadr pa))                    ; pick point on first line
           (setq enda (osnap pta "endpoint"))      ; endpoint of first line
           (setq ptb (cadr pb))                    ; pick point on second line
           (setq endb (osnap ptb "endpoint"))))    ; endpoint of second line
  (if (and enda endb)
      (progn
 ; Ŀ
 ;   The next line assumes that the first pick point is not the endpoint   
 ;   of the line.  (If it is then the angle will be set to 0.)             
 ; 
           (setq angg (angle pta enda))
 ; Ŀ
 ;   Now have two endpoints.  Want to find the bracket end and centre      
 ;   points.  The centre is halfway between the ends and 5 units in the    
 ;   direction away from the lines.                                        
 ; 
           (setq abang (angle enda endb))
           (setq abdist (distance enda endb))
           (setq pa (polar enda abang (/ abdist 2.0)))
           (setq pa (polar pa angg 5))
 ; Ŀ
 ;   The end, being closer to the lines, is 1.25 units up from the higher  
 ;   of enda and endb, and 2.5 units away in direction angg.               
 ; 
           (if (> (cadr enda) (cadr endb))
               (setq pk (polar (polar enda (* pi 0.5) 1.25) angg 2.5))
               (setq pk (polar (polar endb (* pi 0.5) 1.25) angg 2.5)))
 ; Ŀ
 ;   Calculate the various points needed to draw the bracket.              
 ;   (That's "zagrada" in Croatian.)                                       
 ; 
           (setq xpa (car pa))
           (setq ypa (cadr pa))
           (setq xpk (car pk))
           (setq ypk (cadr pk))
           (setq verti (abs (- ypk ypa)))
           (setq horiz (abs (- xpk xpa)))
           (if (> horiz verti)
               (progn
                   (setq radi (/ verti 2))
                   (setq height horiz)
                   (if (> ypk ypa)
                       (progn
                           (setq angg (/ pi 2))
                           (if (> xpk xpa)
                               (setq pk (polar pk (+ angg (/ pi 2))
                                                  (* 2 height)))))
                       (progn
                           (setq angg (* pi 1.5))
                           (if (< xpk xpa)
                               (setq pk (polar pk (+ angg (/ pi 2))
                                                  (* 2 height)))))))
               (progn
                   (setq radi (/ horiz 2))
                   (setq height verti)
                   (if (> xpk xpa)
                       (progn
                           (setq angg 0)
                           (if (< ypk ypa)
                               (setq pk (polar pk (+ angg (/ pi 2))
                                                  (* 2 height)))))
                       (progn
                           (setq angg pi)
                           (if (> ypk ypa)
                               (setq pk (polar pk (+ angg (/ pi 2))
                                                  (* 2 height))))))))
 ; Ŀ
 ;   At this point we temporarily abandon correct indentation in favour    
 ;   of legibility.                                                        
 ; 
  (setq p2 (polar pk (+ angg (* pi 1.5)) radi))  ; centre of first arc
  (setq p3 (polar p2 (+ angg pi) radi))          ; arc end, line start
  (setq p4 (polar p3 (+ angg (* pi 1.5)) (- height (* 2 radi)))) ; line end
  (setq p5 (polar p4 (+ angg pi) radi))          ; 2nd arc centre
  (setq p6 (polar p5 (+ angg (* pi 1.5)) radi))  ; midpoint
  (setq p7 (polar p6 (+ angg (* pi 1.5)) radi))  ; 3rd arc centre
  (setq p8 (polar p7 angg radi))                 ; 3rd arc end, 2nd line start
  (setq p9 (polar p8 (+ angg (* pi 1.5)) (- height (* 2 radi)))) ; line end
  (setq p10 (polar p9 angg radi))                ; 4th arc centre
  (setq p11 (polar p10 (+ angg (* pi 1.5)) radi)); final arc end
 ; Ŀ
 ;   Now draw the bracket.                                                 
 ; 
           (command "pline" pk "arc" "ce" p2 p3
                               "line" p4
                               "arc" "a" "-90" p6 "a" "-90" p8
                               "line" p9
                               "arc" "ce" p10 p11 ""))
 ; Ŀ
 ;   Error message if object selections were doubtful.                     
 ; 
      (write-line "\nNeed 2 lines."))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "blipmode" blip)
  (setvar "osmode" oss)
 (princ))